/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionException;
import com.floragunn.signals.watch.common.HttpEndpointWhitelist;
import com.floragunn.signals.watch.common.WatchElement;
import com.floragunn.signals.watch.common.auth.Auth;
import com.floragunn.signals.watch.common.auth.BasicAuth;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpRequestConfig
extends WatchElement
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(HttpRequestConfig.class);
    private Method method;
    private String accept;
    private URI uri;
    private String path;
    private String queryParams;
    private String body;
    private Map<String, String> headers;
    private Auth auth;
    private TemplateScript.Factory pathTemplateScriptFactory;
    private TemplateScript.Factory queryParamsTemplateScriptFactory;
    private TemplateScript.Factory bodyTemplateScriptFactory;
    private Map<String, TemplateScript.Factory> headerTemplateScriptFactories;

    public HttpRequestConfig(Method method, URI uri, String path, String queryParams, String body, Map<String, String> headers, Auth auth, String accept) {
        this.method = method;
        this.uri = uri;
        this.path = path;
        this.queryParams = queryParams;
        this.body = body;
        this.headers = headers;
        this.auth = auth;
        this.accept = accept;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void compileScripts(WatchInitializationService watchInitializationService) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.bodyTemplateScriptFactory = watchInitializationService.compileTemplate("body", this.body, validationErrors);
        this.pathTemplateScriptFactory = watchInitializationService.compileTemplate("path", this.path, validationErrors);
        this.queryParamsTemplateScriptFactory = watchInitializationService.compileTemplate("query_params", this.queryParams, validationErrors);
        this.headerTemplateScriptFactories = Optional.ofNullable(this.getHeaders()).orElseGet(Collections::emptyMap).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> watchInitializationService.compileTemplate("headers." + (String)entry.getKey(), (String)entry.getValue(), validationErrors)));
        validationErrors.throwExceptionForPresentErrors();
    }

    public HttpUriRequest createHttpRequest(WatchExecutionContext ctx) throws UnsupportedEncodingException, WatchExecutionException, HttpEndpointWhitelist.NotWhitelistedException {
        URI uri = this.getRenderedUri(ctx);
        this.checkWhitelist(ctx, uri);
        HttpUriRequest result = this.createHttpRequest(uri, this.method);
        Map<String, String> renderedHeaders = this.getRenderedHeaders(ctx);
        for (Map.Entry<String, String> header : renderedHeaders.entrySet()) {
            result.setHeader(header.getKey(), header.getValue());
        }
        if (this.auth instanceof BasicAuth) {
            BasicAuth basicAuth = (BasicAuth)this.auth;
            String encodedAuth = Base64.getEncoder().encodeToString((basicAuth.getUsername() + ":" + basicAuth.getPassword()).getBytes());
            result.setHeader("Authorization", "Basic " + encodedAuth);
        }
        String body = null;
        if (result instanceof HttpEntityEnclosingRequestBase) {
            body = this.getRenderedBody(ctx);
            ((HttpEntityEnclosingRequestBase)result).setEntity((HttpEntity)new StringEntity(body));
        }
        if (log.isDebugEnabled()) {
            log.debug("Rendered HTTP request:\n" + result + "\n" + body);
        }
        return result;
    }

    public void checkHttpResponse(HttpRequest request, HttpResponse response) throws WatchExecutionException {
        if (response.getEntity() == null || response.getEntity().getContentType() == null || response.getEntity().getContentType().getValue() == null) {
            return;
        }
        String receivedContentType = response.getEntity().getContentType().getValue();
        String accept = this.accept;
        if (accept == null && this.headers != null && this.headers.containsKey("Accept")) {
            accept = this.headers.get("Accept");
        }
        if (accept != null) {
            String[] acceptedContentTypes = accept.split(",\\s*");
            boolean acceptedContentTypeFound = false;
            for (String acceptedContentType : acceptedContentTypes) {
                if (acceptedContentType.contains(";")) {
                    acceptedContentType = acceptedContentType.substring(0, acceptedContentType.indexOf(59));
                }
                if (!receivedContentType.equalsIgnoreCase(acceptedContentType)) continue;
                acceptedContentTypeFound = true;
            }
            if (!acceptedContentTypeFound) {
                throw new WatchExecutionException("Web service at " + request.getRequestLine().getUri() + " returned the Content-Type " + receivedContentType + "; The content types configured to be accepted are: " + accept, null);
            }
        }
    }

    private void checkWhitelist(WatchExecutionContext ctx, URI uri) throws HttpEndpointWhitelist.NotWhitelistedException {
        if (ctx.getHttpEndpointWhitelist() != null) {
            ctx.getHttpEndpointWhitelist().check(uri);
        }
    }

    private HttpUriRequest createHttpRequest(URI url, Method method) throws UnsupportedEncodingException, WatchExecutionException {
        switch (method) {
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case GET: {
                return new HttpGet(url);
            }
        }
        throw new WatchExecutionException("Unsupported request method " + (Object)((Object)method), null);
    }

    private URI getRenderedUri(WatchExecutionContext ctx) throws WatchExecutionException {
        try {
            if (this.path == null && this.queryParams == null) {
                return this.uri;
            }
            String renderedPath = this.uri.getPath();
            String renderedQueryParams = this.uri.getQuery();
            Map<String, Object> runtimeData = ctx.getTemplateScriptParamsAsMap();
            if (this.pathTemplateScriptFactory != null) {
                renderedPath = this.pathTemplateScriptFactory.newInstance(runtimeData).execute();
            }
            if (this.queryParamsTemplateScriptFactory != null) {
                renderedQueryParams = this.queryParamsTemplateScriptFactory.newInstance(runtimeData).execute();
            }
            return new URI(this.uri.getScheme(), this.uri.getAuthority(), renderedPath, renderedQueryParams, this.uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new WatchExecutionException(e.getMessage(), null);
        }
    }

    private String getRenderedBody(WatchExecutionContext ctx) {
        if (this.body == null) {
            return "";
        }
        Map<String, Object> runtimeData = ctx.getTemplateScriptParamsAsMap();
        return this.bodyTemplateScriptFactory.newInstance(runtimeData).execute();
    }

    private Map<String, String> getRenderedHeaders(WatchExecutionContext ctx) {
        Map<String, Object> runtimeData = ctx.getTemplateScriptParamsAsMap();
        return this.headerTemplateScriptFactories.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TemplateScript.Factory)entry.getValue()).newInstance(runtimeData).execute()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("method", (Enum)this.method);
        if (this.uri != null) {
            builder.field("url", String.valueOf(this.uri));
        }
        builder.field("body", this.body);
        if (this.headers != null) {
            builder.field("headers", this.headers);
        }
        if (this.auth != null) {
            builder.field("auth");
            this.auth.toXContent(builder, params);
        }
        if (this.path != null) {
            builder.field("path", this.path);
        }
        if (this.queryParams != null) {
            builder.field("query_params", this.queryParams);
        }
        if (this.accept != null) {
            builder.field("accept", this.accept);
        }
        builder.endObject();
        return builder;
    }

    public static HttpRequestConfig create(WatchInitializationService watchInitService, DocNode objectNode) throws ConfigValidationException {
        HttpRequestConfig result = HttpRequestConfig.createWithoutCompilation(objectNode);
        result.compileScripts(watchInitService);
        return result;
    }

    public static HttpRequestConfig createWithoutCompilation(DocNode objectNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(objectNode, validationErrors);
        Method method = (Method)vJsonNode.get("method").withDefault((Enum)Method.POST).asEnum(Method.class);
        URI uri = vJsonNode.get("url").required().asURI();
        String body = vJsonNode.get("body").asString();
        String path = vJsonNode.get("path").asString();
        String queryParams = vJsonNode.get("query_params").asString();
        String accept = vJsonNode.get("accept").asString();
        Map<String, String> headers = HttpRequestConfig.extractHeadersFromDocNode(vJsonNode, validationErrors);
        Auth auth = (Auth)vJsonNode.get("auth").by(Auth::create);
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new HttpRequestConfig(method, uri, path, queryParams, body, headers, auth, accept);
    }

    private static Map<String, String> extractHeadersFromDocNode(ValidatingDocNode vJsonNode, ValidationErrors validationErrors) {
        if (!vJsonNode.hasNonNull("headers")) {
            return null;
        }
        return vJsonNode.getAsDocNode("headers").keySet().stream().collect(Collectors.toMap(key -> key, key -> {
            String headerValue = vJsonNode.get("headers").asValidatingDocNode().get(key).asString();
            if (headerValue == null) {
                validationErrors.add(new ValidationError("headers." + key, "Value cannot be null"));
                return "null";
            }
            return headerValue;
        }));
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public static enum Method {
        POST,
        PUT,
        DELETE,
        GET;

    }
}

